/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.config.jsons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Path;
import mod.beethoven92.betterendforge.common.util.JsonFactory;
import net.minecraftforge.fml.loading.FMLPaths;

public class JsonConfigWriter {
    private static final Path GAME_CONFIG_DIR = new File(String.valueOf(FMLPaths.CONFIGDIR.get())).toPath();
    public static final File MOD_CONFIG_DIR = new File(GAME_CONFIG_DIR.toFile(), "betterendforge");
    private final File configFile;
    private JsonObject configObject;

    public JsonConfigWriter(String configFile) {
        this.configFile = new File(MOD_CONFIG_DIR, configFile + ".json");
        this.load();
    }

    public JsonObject getConfig() {
        return this.configObject;
    }

    public void save() {
        if (this.configObject == null) {
            return;
        }
        JsonConfigWriter.save(this.configFile, (JsonElement)this.configObject);
    }

    public JsonObject load() {
        if (this.configObject == null) {
            this.configObject = JsonConfigWriter.load(this.configFile);
        }
        return this.configObject;
    }

    public void save(JsonElement config) {
        this.configObject = config.getAsJsonObject();
        JsonConfigWriter.save(this.configFile, config);
    }

    public static JsonObject load(File configFile) {
        return JsonFactory.getJsonObject(configFile);
    }

    public static void save(File configFile, JsonElement config) {
        JsonFactory.storeJson(configFile, config);
    }

    public static String scrubFileName(String input) {
        input = input.replaceAll("[/\\ ]+", "_");
        input = input.replaceAll("[,:&\"\\|\\<\\>\\?\\*]", "_");
        return input;
    }

    static {
        if (!MOD_CONFIG_DIR.exists()) {
            MOD_CONFIG_DIR.mkdirs();
        }
    }
}

